================================================================================
TITLE "Adjustment of the Lab2_Reported_Oil Composition"
================================================================================

NOTE: "The Lab2_Reported_Oil composition is inconsistent with the"
NOTE: "measured saturation pressure and GOR. It must be adjusted."
NOTE: ""
NOTE: "Adjust the C30+ amount in the residual oil of the 2-stage separation"
NOTE: "and recombine the residual with the two removed gases, according to"
NOTE: "the reported mass ratios."

-- Convert, renormalize, and report (if LaTeX is on) the residual liquid
-- from the two-stage separation of the Lab2 surface sample:

LMIX Lab2_Reported_Sep2_Res 1 MOLE Lab2_Reported_Sep2_Res

-- Copy the mixture to one that will be adjusted:

QIX Lab2_Adjusted_Sep2_Res 1 MASS Lab2_Reported_Sep2_Res

-- Adjust the C30+ mass by the Lab2_Res_C30X multiplier:

MULTIPLY MASS of C30+ in Lab2_Adjusted_Sep2_Res by Lab2_Res_C30X

-- Renormalize and report (if LaTeX is on) the adjusted residual liquid:

LMIX Lab2_Adjusted_Sep2_Res 1 MOLE Lab2_Adjusted_Sep2_Res

-- Recombine the adjusted residual liquid and the two reported separator gases,
-- using the reported recombination mass ratios:

QIX Lab2_Recombined_Oil: 1 Mass Lab2_Adjusted_Sep2_Res
                         0.04912 Mass Lab2_Reported_Sep2_Gas2
                         0.09746 Mass Lab2_Reported_Sep2_Gas1

-- Renormalize and report (if LaTeX is on) the adjusted, recombined oil:

LMIX Lab2_Recombined_Oil 1 MOLE Lab2_Recombined_Oil

================================================================================
TITLE "Adjustment of the Lab2_Reported_Slimtube_Oil Composition"
================================================================================

NOTE: "The Lab2_Reported_Slimtube_Oil composition is inconsistent with the"
NOTE: "measured saturation pressure and GOR. It must be adjusted."

-- Convert, renormalize, and report (if LaTeX is on) the reported sample
-- composition for the Lab2 slimtube experiments:

LMIX Lab2_Reported_Slimtube_Oil 1 MOLE Lab2_Reported_Slimtube_Oil

-- Copy the reported sample to the FEED stream and perform a saturation pressure
-- calculation at reservoir temperature. The experimental saturation pressure
-- was 3650 psig. The calculated value (if different) will be indicative of
-- how much adjustment the composition will require.

QIX FEED Lab2_Reported_Slimtube_Oil
TEMP 204 F, PRES PSIG, SATP

NOTE: "Flash the reported composition at ambient conditions"
NOTE: "to estimate the flashed liquid and flashed vapor compositions."

TEMP 68 F, PRES 1 atm, FLASH
QIX FlashedLiquid NFL
QIX FlashedVapor  NFV

NOTE: "Modify the C30+ content of the flashed liquid"

MULTIPLY MOLES of C30+ in FlashedLiquid by Lab2_Slim_C30X
MIX FlashedLiquid 1 MOLE FlashedLiquid

NOTE: "Recombine the flashed vapor with the adjusted flashed Liquid"
NOTE: "to the measured saturation pressure."

TEMP 204 F, PRES 3650 PSIG
QIX FEED 0.2 MASS FlashedVapor 1 TMASS FlashedLiquid ; should be 2-phase
BOUND MIXTURE FlashedLiquid ; FlashedLiquid will be 1-phase,
                            ; so the boundary mixture should be saturated

-- Save and report (if LaTeX is on) the resulting, saturated feed stream:

LMIX Lab2_Slimtube_Oil FEED
